ORCA/M Asm65816 2.1.0

0001 BFB5                       title 'MessageByName' 
0002 BFB5              **********************************************************************
0003 BFB5              *
0004 BFB5              * MessageByName
0005 BFB5              *
0006 BFB5              * Copyright 1988,1989
0007 BFB5              * Apple Computer, Inc.
0008 BFB5              * All Rights Reserved.
0009 BFB5              *
0010 BFB5              * Original Code by Pete MacDonald
0011 BFB5              * converted to MAX by Steven Glass
0012 BFB5              *
0013 BFB5              * This file contains the code to implement the function MessageByName.
0014 BFB5              *
0015 BFB5              *
0016 BFB5              * 3/30/89           Mensch
0017 BFB5              * Fixed bug that allowed only 63 byte names instead of 64 byte names.
0018 BFB5              *
0019 BFB5              **********************************************************************
0020 BFB5
0021 BFB5                       include 'all.macros' 
0022 BFB5
0023 BFB5              ;------------------------------------------
0024 BFB5              ;
0025 BFB5              ; Equates from procedure MessageData
0026 BFB5              ;
0027 BFB5              ;------------------------------------------
0028 BFB5              IdNotAvailable equ $0112                ;new error means all Id's used up
0029 BFB5              MessNotFound equ $0111                  ;Did not find the requested message.
0030 BFB5              NameTooLong equ $0113                   ;Name was longer than 64 chars.
0031 BFB5              MemId    equ $9001                      ;Mem manager's ID
0032 BFB5              oMessageId equ 4                        ;offset in message record to ID
0033 BFB5              IncBusy  equ $e10064                    ;system utility increment the busy flag
0034 BFB5              BusyStrip equ $e10180                   ;" decrement busy, fix stack
0035 BFB5
0036 BFB5
0037 BFB5
0038 BFB5                       DefineStack 
0039 BFB5              NumMessages word                        ; total number of develper type messages
0040 BFB5              MessageHandle long                      ; general use handle for messages
0041 BFB5              MaxID    word                           ; highest ID found during scan
0042 BFB5              Pointer  long                           ; general use pointer
0043 BFB5              NamePtr  long                           ; pointer to name string (for compare)
0044 BFB5              Direct   word 
0045 BFB5              RTL1     block 3 
0046 BFB5              RTL2     block 3 
0047 BFB5              RecordPtr long                          ; pointer to input record
0048 BFB5              CreateIt word                           ; Create flag.  Used if no msg is found.
0049 BFB5              IDTemp   word                           ; space supplied by caller
0050 BFB5              CFlag    word                           ; space supplied by caller
0051 BFB5
0052 BFB5
0053 BFB5              localbytes equ Direct-1                 ;direct -1 = number of bytes in locals.
0054 BFB5
0055 BFB5              ;-----------------------------------------------
0056 BFB5              ;
0057 BFB5              ;   Forward addresses and entries
0058 BFB5              ;
0059 BFB5              ;-----------------------------------------------
0060 BFB5
0061 BFB5                       ENTRY AddPtr 
0062 BFB5                       ENTRY DeLink 
0063 BFB5                       ENTRY DerefNGetType 
0064 BFB5                       ENTRY DoHoles 
0065 BFB5                       ENTRY GetFirst 
0066 BFB5                       ENTRY IsitMe 
0067 BFB5                       ENTRY Main 
0068 BFB5                       ENTRY MakeIt 
0069 BFB5
0070 BFB5
0071 BFB5
0072 BFB5                       eject 
0073 BFB5              ****************************************************************
0074 BFB5              *
0075 BFB5              MessageByName PROC EXPORT 
0076 BFB5              *
0077 BFB5              * function MessageByName (CreateFlag : boolean; RecordPtr : LONG ) : LONG
0078 BFB5              *
0079 BFB5              * This is the function entry point. It takes 3 inputs.
0080 BFB5              * a word space for the returned ID, a word for the create/found
0081 BFB5              * flag, and a long pointer to the record that contains the name string
0082 BFB5              * that Identifies the the message we want to find/create, as well as
0083 BFB5              * an optional block of data with which to initialize the message if
0084 BFB5              * it's to be created..
0085 BFB5              *
0086 BFB5              *
0087 BFB5              * Inputs:
0088 BFB5              *                   space for result    : LONG
0089 BFB5              *                   CreateFlag          : WORD
0090 BFB5              *                   RecordPtr           : LONG
0091 BFB5              *
0092 BFB5              * Outputs:
0093 BFB5              *                   CreatedFlag         : WORD
0094 BFB5              *                   MessageNumber       : WORD
0095 BFB5              *
0096 BFB5              * External Refs:
0097 BFB5              *                   none
0098 BFB5              *
0099 BFB5              * Entry Points:
0100 BFB5              *                   none
0101 BFB5              *
0102 BFB5                       longa on                       ; mode
0103 BFB5                       longi on
0104 BFB5              *
0105 BFB5              ****************************************************************
0106 BFB5
0107 BFB5
0108 BFB5 0B                    phd                            ;save direct page under params
0109 BFB6 3B                    tsc                            ;current stack <Pointer
0110 BFB7 38                    sec                            ;ready for subtract
0111 BFB8 E9 10 00              sbc   #localbytes              ;number of locals
0112 BFBB 1B                    tcs                            ;new stack <Pointer
0113 BFBC 5B                    tcd                            ;get the new direct page-1
0114 BFBD
0115 BFBD 64 01                 stz   <NumMessages             ;init number of messages counter
0116 BFBF 64 07                 stz   <MaxId                   ;init highest Id var.
0117 BFC1
0118 BFC1
0119 BFC1 18                    clc                            ;init namePtr,
0120 BFC2 A5 19                 lda   <RecordPtr               ;so that it points past the
0121 BFC4 69 02 00              adc   #2                       ;len word in record
0122 BFC7 85 0D                 sta   <NamePtr
0123 BFC9 A5 1B                 lda   <RecordPtr+2
0124 BFCB 69 00 00              adc   #0
0125 BFCE 85 0F                 sta   <NamePtr+2
0126 BFD0
0127 BFD0 22 64 00 E1           jsl   IncBusy
0128 BFD4
0129 BFD4 A7 0D                 lda   [<NamePtr]               ;validate length of string.(source)
0130 BFD6 29 FF 00              and   #$00FF                   ; strip to get the length byte
0131 BFD9 C9 41 00              cmp   #65                      ;is the low byte bigger than 64 ?
0132 BFDC 90 05                 blt   GoodLen                  ;taken if not
0133 BFDE              ;
0134 BFDE              ; was
0135 BFDE              ;        bit   #$00c0
0136 BFDE              ;        beq   GoodLen
0137 BFDE              ;
0138 BFDE              ;?????????????????????????????should we also check if record len enough for name
0139 BFDE A9 13 01              lda   #NameTooLong
0140 BFE1 80 03                 bra   Split
0141 BFE3
0142 BFE3              GoodLen                                 ; 
0143 BFE3
0144 BFE3 20 F5 BF              jsr   Main                     ;go to work
0145 BFE6
0146 BFE6 AA           Split    tax                            ;pass error to BusyStrip
0147 BFE7
0148 BFE7 3B                    tsc                            ;remove locals
0149 BFE8 18                    clc   
0150 BFE9 69 10 00              adc   #LocalBytes
0151 BFEC 1B                    tcs   
0152 BFED
0153 BFED 2B                    pld                            ;and direct page
0154 BFEE
0155 BFEE A0 06 00              ldy   #6                       ;num input bytes to strip for BusyStrip
0156 BFF1
0157 BFF1 5C 80 01 E1           jml   BusyStrip                ;This decs busy, fixes stack, sets error
0158 BFF5
0159 BFF5                       ENDP 
0160 BFF5
0161 BFF5                       title 'MessageByName -- Main' 
0162 BFF5              ****************************************************************
0163 BFF5              *
0164 BFF5              Main     PROC 
0165 BFF5              *
0166 BFF5              * Scan all messages in the developer range (i.e 8000-$ffff) of message types,
0167 BFF5              * looking for one that contains the same ID string as was requested.
0168 BFF5              * Also noting the number of developer range messages that are used, as well
0169 BFF5              * as the largest used message Id. If no messages exist at all, then create one
0170 BFF5              * with ID $8000, and set Cflag true indicating that a new message was created
0171 BFF5              * If a message with the requested Id string is found, then copy the input record
0172 BFF5              * to it, and return it's Id, set cflag false saying message was not created, but
0173 BFF5              * rather we are returning the ID of an existing message that contains the same
0174 BFF5              * Id String as was requested. If there is no message with the Id String we
0175 BFF5              * are looking for then check NumMessages, and MaxID to see if there are any
0176 BFF5              * holes, if there aren't any holes, (i.e. MaxId - $8000 = NumMessages) and the
0177 BFF5              * last used Id (MaxId = $ffff) then all Id's are used up, and we return error
0178 BFF5              * # $0112 IdNotAvailable. If MaxId-$8000 > NumMessages, then there is a hole.
0179 BFF5              * At that point the list is again scanned, until the first hole is found,
0180 BFF5              * and the hole's Id is then the Id used to create the message, and Cflag is
0181 BFF5              * set true indicating a newly created message Id. If there were no holes,
0182 BFF5              * and MaxId < $ffff, then MaxId + 1 is used to create a new message, and
0183 BFF5              * clag is set true to indicate that we did create a message.
0184 BFF5              *
0185 BFF5              *
0186 BFF5              * Inputs:
0187 BFF5              *                   all on direct page
0188 BFF5              *
0189 BFF5              * Outputs:
0190 BFF5              *                   all on direct page
0191 BFF5              *
0192 BFF5              * External Refs:
0193 BFF5              *                   none
0194 BFF5              *
0195 BFF5              * Entry Points:
0196 BFF5              *                   none
0197 BFF5              *
0198 BFF5                       longa on                       ; mode
0199 BFF5                       longi on
0200 BFF5              *
0201 BFF5              ****************************************************************
0202 BFF5
0203 BFF5
0204 BFF5 20 FD C0              jsr   GetFirst                 ;get Pointer to the first message record
0205 BFF8 F0 45                 beq   NoDevIds                 ;if 0 then no messages
0206 BFFA
0207 BFFA 20 15 C1     Loop     jsr   DerefNGetType            ;deref Handle to Pointer and get type.
0208 BFFD AA                    tax                            ;type -> x for later.
0209 BFFE 10 27                 bpl   AroundAgain              ;if < $8000 it's not a developer type
0210 C000
0211 C000 E6 01                 inc   <NumMessages             ;up count of developer messages found
0212 C002 A5 0B 48 A5           pushlong <pointer 
0213 C008 20 C2 C0              jsr   IsitMe
0214 C00B A8                    tay                            ;is this record the same type as requ ?
0215 C00C 68 85 09 68           pulllong <pointer 
0216 C012 98                    tya   
0217 C013 D0 0C                 bne   NoMatch                  ;set Z says it was the one I want
0218 C015
0219 C015 86 1F                 stx   <IdTemp                  ;set Id to the one we found,
0220 C017 A5 1D                 lda   <CreateIt                ;pre-check createit before we call
0221 C019 F0 03                 beq   NoMake                   ;makeit. to insure proper error result.
0222 C01B
0223 C01B 20 51 C0              jsr   MakeIt                   ;re-create message with input record
0224 C01E
0225 C01E 64 21        NoMake   stz   <Cflag                   ;say it's an existing message
0226 C020 60                    rts                            ;and split
0227 C021
0228 C021 E4 07        NoMatch  cpx   <MaxId                   ;is Id bigger than biggest found (MaxID)
0229 C023 90 02                 blt   AroundAgain              ;taken if current Id < than max ID
0230 C025
0231 C025 86 07                 stx   <MaxId                   ;current ID is > MaxId so update MaxID
0232 C027
0233 C027 20 30 C1     AroundAgain jsr   DeLink                ;get and validate forward link
0234 C02A D0 CE                 bne   Loop                     ;taken if there is a valid handle
0235 C02C
0236 C02C A5 07                 lda   <MaxId                   ;compare to the highest used Id
0237 C02E 10 0F                 bpl   NoDevIds                 ;if < $8000 then no developer Ids exist
0238 C030 29 FF 7F              and   #$7fff                   ;this works cause we only look at $8000+
0239 C033 1A                    inc   a                        ;MaxId + 1 cause we start at 0 not 1
0240 C034 C5 01                 cmp   <NumMessages             ;total number of developer messages.
0241 C036 F0 0F                 beq   NoHoles                  ;if = then no holes so check max
0242 C038 4C E2 C0              jmp   DoHoles                  ;else go find one of the holes.
0243 C03B              ;        rts                            !!! EXIT !!!
0244 C03B
0245 C03B A9 12 01     GiveUp   lda   #IdNotAvailable          ;say all Id's are used up
0246 C03E 60                    rts   
0247 C03F
0248 C03F A9 00 80 85  NoDevIds MoveWord #$8000,<IdTemp        ;set Id to first developer ID
0249 C044 4C 51 C0              jmp   Makeit                   ;Make 1 with this ID and exit from there
0250 C047              ;        rts                            !!!EXIT!!!
0251 C047
0252 C047 A5 07        NoHoles  lda   <MaxId                   ;Get Max Id
0253 C049 1A                    inc   a                        ;add one to point at next available
0254 C04A F0 EF                 beq   GiveUp                   ;if 0 then none are left error out.
0255 C04C
0256 C04C 85 1F                 sta   <IdTemp                  ;maxid+1 = next avaialable ID
0257 C04E 4C 51 C0              jmp   Makeit                   ;use it and make a new message.
0258 C051              ;        rts                            !!!EXIT!!!
0259 C051                       ENDP 
0260 C051
0261 C051                       title 'MessageByName -- MakeIt' 
0262 C051              ****************************************************************
0263 C051              *
0264 C051              MakeIt   PROC 
0265 C051              *
0266 C051              * Make a message with the name we were passed, and the Id in IdTemp
0267 C051              *
0268 C051              *
0269 C051              * Inputs:
0270 C051              *                   on direct page
0271 C051              *
0272 C051              * Outputs:
0273 C051              *                   on direct page
0274 C051              *
0275 C051              * External Refs:
0276 C051              *                   none
0277 C051              *
0278 C051              * Entry Points:
0279 C051              *                   none
0280 C051              *
0281 C051                       longa on                       ; mode
0282 C051                       longi on
0283 C051              *
0284 C051              ****************************************************************
0285 C051
0286 C051
0287 C051 A5 1D                 lda   <CreateIt                ;am I supposed to create a message ?
0288 C053 D0 04                 bne   DoMake                   ;if non 0 then yes, so continue.
0289 C055 A9 11 01              lda   #MessNotFound            ;Else say the message wasn't found
0290 C058 60                    rts                            ;and split
0291 C059
0292 C059
0293 C059 48           DoMake   pha                            ;handle for message/space for newhandle
0294 C05A 48                    pha   
0295 C05B
0296 C05B 18                    clc                            ;push the len of the record + 6 overhead
0297 C05C A7 19                 lda   [<RecordPtr]             ;the entire data block i.e. the word len
0298 C05E 69 06 00              adc   #6                       ;plus the string, and it's len. + the 6
0299 C061 AA                    tax                            ;bytes of overhead.
0300 C062 A9 00 00              lda   #0                       ;synth a high word lda #0 ,rol a. will
0301 C065 2A                    rol   a                        ;save one byte versus lda #0, adc #0
0302 C066 48                    pha                            ;push the hibyte of the block len.
0303 C067 DA                    phx                            ;and the low byte.
0304 C068
0305 C068 F4 01 90              PushWord #MemId                ;My ID
0306 C06B F4 00 00              PushWord #0                    ;attributes
0307 C06E 48                    pha                            ;this is the where long. but
0308 C06F 48                    pha                            ;since it's not used. we need't use 0's
0309 C070 A2 02 09 22           _NewHandle 
0310 C077 AA                    tax                            ;save error if any
0311 C078 68 85 03 68           PullLong <MessageHandle        ;get the handle
0312 C07E 90 02                 bcc   KeepGoing                ;if no error keep going.
0313 C080 8A                    txa                            ;recover the error code.
0314 C081 60                    rts   
0315 C082
0316 C082 20 15 C1     KeepGoing jsr   DerefNGetType           ;deref messghandle to Pointer lose type.
0317 C085
0318 C085 A9 06 00              lda   #6                       ;set pointer just past the standard
0319 C088 20 26 C1              jsr   AddPtr                   ;message overhead of 6 bytes.
0320 C08B
0321 C08B A7 19                 lda   [<RecordPtr]             ;get the record len
0322 C08D A8                    tay                            ;to y for copy
0323 C08E 88                    dey                            ;- 1 cause we copy from len-1 down to 0
0324 C08F
0325 C08F E2 20                 sep   #$20
0326 C091                       LongA Off
0327 C091
0328 C091 B7 19        CopyLp   lda   [<RecordPtr],y           ;copy the name to handle
0329 C093 97 09                 sta   [<Pointer],y
0330 C095 88                    dey                            ;next one
0331 C096 10 F9                 bpl   CopyLp
0332 C098
0333 C098 C2 20                 rep   #$20
0334 C09A                       LongA On
0335 C09A
0336 C09A F4 01 00              PushWord #1                    ;now create a message with the name
0337 C09D A5 1F 48              PushWord <IdTemp               ;we were passed, and the ID we
0338 C0A0 A5 05 48 A5           PushLong <MessageHandle        ;found available.
0339 C0A6 A2 01 15 22           _MessageCenter 
0340 C0AD 48                    pha                            ;save error result
0341 C0AE
0342 C0AE A9 FF FF 85           MoveWord #$ffff,<Cflag         ;say we actually created this record
0343 C0B3
0344 C0B3 A5 05 48 A5  Exit     PushLong <MessageHandle        ;dump the handle we created
0345 C0B9 A2 02 10 22           _DisposeHandle 
0346 C0C0
0347 C0C0 68                    pla                            ;recover the error result
0348 C0C1 60                    rts                            ;done and split
0349 C0C2                       ENDP 
0350 C0C2
0351 C0C2                       title 'MessageByName -- IsItMe' 
0352 C0C2
0353 C0C2              ****************************************************************
0354 C0C2              *
0355 C0C2              IsitMe   PROC 
0356 C0C2              *
0357 C0C2              * Check to see if the message we got has the same name as was
0358 C0C2              * passed to us by the caller. Z flag is used to indicate match or not.
0359 C0C2              *
0360 C0C2              *
0361 C0C2              * Inputs:
0362 C0C2              *                   on direct page
0363 C0C2              *
0364 C0C2              * Outputs:
0365 C0C2              *                   z-flag
0366 C0C2              *
0367 C0C2              * External Refs:
0368 C0C2              *                   none
0369 C0C2              *
0370 C0C2              * Entry Points:
0371 C0C2              *                   none
0372 C0C2              *
0373 C0C2                       longa on                       ; mode
0374 C0C2                       longi on
0375 C0C2              *
0376 C0C2              ****************************************************************
0377 C0C2
0378 C0C2
0379 C0C2 A9 08 00              lda   #8                       ;skip the link and Id fields (6)
0380 C0C5 20 26 C1              jsr   AddPtr                   ;and skip word of data len (2)=8 bytes
0381 C0C8
0382 C0C8 A9 00 00              lda   #0000                    ;set a to zero for when we sep #$20
0383 C0CB
0384 C0CB                       longa Off
0385 C0CB E2 20                 sep   #$20
0386 C0CD
0387 C0CD A7 0D                 lda   [<NamePtr]               ;get the name len from input record
0388 C0CF C7 09                 cmp   [<Pointer]               ;(name in message)
0389 C0D1 D0 0C                 bne   Exit                     ;if not same len try next ID
0390 C0D3
0391 C0D3 A8                    tay                            ;move len to y for count and index
0392 C0D4
0393 C0D4 B7 0D        NameLp   lda   [<NamePtr],y             ;7 bit compare the name strings.(source)
0394 C0D6 57 09                 eor   [<Pointer],y             ;blend with name in message
0395 C0D8 29 7F                 and   #$7f                     ;clear the msb
0396 C0DA D0 03                 bne   Exit                     ;if they are same try the next one
0397 C0DC
0398 C0DC 88                    dey                            ;else next char to check
0399 C0DD D0 F5                 bne   NameLp                   ;don't check the zero'th char.(i.e.Len)
0400 C0DF
0401 C0DF              Exit      
0402 C0DF                       longa on
0403 C0DF C2 20                 rep   #$20
0404 C0E1 60                    rts   
0405 C0E2                       ENDP 
0406 C0E2
0407 C0E2                       title 'MessageByName -- DoHoles' 
0408 C0E2              ****************************************************************
0409 C0E2              *
0410 C0E2              DoHoles  PROC 
0411 C0E2              *
0412 C0E2              * Scan the message list looking for $8000.8001.8002.etc. as soon
0413 C0E2              * one is not found in the list we know it's a hole, and we use it
0414 C0E2              * to create a message
0415 C0E2              *
0416 C0E2              *
0417 C0E2              * Inputs:
0418 C0E2              *                   none
0419 C0E2              *
0420 C0E2              * Outputs:
0421 C0E2              *                   none
0422 C0E2              *
0423 C0E2              * External Refs:
0424 C0E2              *                   none
0425 C0E2              *
0426 C0E2              * Entry Points:
0427 C0E2              *                   none
0428 C0E2              *
0429 C0E2                       longa on                       ; mode
0430 C0E2                       longi on
0431 C0E2              *
0432 C0E2              ****************************************************************
0433 C0E2
0434 C0E2
0435 C0E2 A9 FF 7F 85           MoveWord #$7fff,<IdTemp        ;init counter to look for holes
0436 C0E7
0437 C0E7 20 FD C0     ScanLp   jsr   GetFirst                 ;get the handle of the first message.
0438 C0EA E6 1F                 inc   <IdTemp
0439 C0EC
0440 C0EC 20 15 C1     Loop     jsr   DerefNGetType            ;deref Messagehandle to Pointer get type
0441 C0EF 10 04                 bpl   NextOne                  ;if taken it's not a developer Id ignore
0442 C0F1
0443 C0F1 C5 1F                 cmp   <IdTemp                  ;it's a dev Id is it the one we want ?
0444 C0F3 F0 F2                 beq   Scanlp                   ;taken if yes to start over with next Id
0445 C0F5
0446 C0F5 20 30 C1     NextOne  jsr   DeLink                   ;get and validate forward link to next
0447 C0F8 D0 F2                 bne   Loop                     ;taken if there is a valid handle
0448 C0FA
0449 C0FA 4C 51 C0              jmp   MakeIt                   ;if we make it here Idtemp = Id of hole
0450 C0FD
0451 C0FD                       ENDP 
0452 C0FD
0453 C0FD
0454 C0FD
0455 C0FD
0456 C0FD                       title 'MessageByName -- Utilities' 
0457 C0FD              **********************************************************************
0458 C0FD              * These are various utility routines.
0459 C0FD              **********************************************************************
0460 C0FD
0461 C0FD              GetFirst PROC 
0462 C0FD              **********************************************************************
0463 C0FD              * Get handle to the first message in the list. It happens to be kept
0464 C0FD              * in the memory managers WAP. Leave it in messagehandle
0465 C0FD              **********************************************************************
0466 C0FD 48                    pha   
0467 C0FE 48                    pha   
0468 C0FF F4 00 00              PushWord #0                    ;system tool
0469 C102 F4 02 00              PushWord #2                    ;memory managers WAP
0470 C105 A2 01 0C 22           _GetWap                        ;get it
0471 C10C
0472 C10C 68                    pla   
0473 C10D 85 03                 sta   <MessageHandle
0474 C10F 68                    pla   
0475 C110 85 05                 sta   <MessageHandle+2
0476 C112 05 03                 ora   <MessageHandle           ;or with low word
0477 C114 60                    rts   
0478 C115              **********************************************************************
0479 C115              * Deref MessageHandle to Pointer. Then return with the message type
0480 C115              * In the a-reg.
0481 C115              **********************************************************************
0482 C115
0483 C115                       entry DerefNGetType 
0484 C115              DerefNGetType                           ;
0485 C115 A7 03                 lda   [<MessageHandle]
0486 C117 85 09                 sta   <Pointer                 ;deref/check this message
0487 C119 A0 02 00              ldy   #2
0488 C11C B7 03                 lda   [<MessageHandle],y
0489 C11E 85 0B                 sta   <Pointer+2
0490 C120
0491 C120 A0 04 00              ldy   #oMessageID              ;offset to message ID
0492 C123 B7 09                 lda   [<Pointer],y             ;get it
0493 C125 60                    rts   
0494 C126
0495 C126
0496 C126              **********************************************************************
0497 C126              * Add a-reg to Pointer result in Pointer
0498 C126              **********************************************************************
0499 C126
0500 C126                       entry AddPtr 
0501 C126              AddPtr                                  ;
0502 C126 18                    clc   
0503 C127 65 09                 adc   <Pointer
0504 C129 85 09                 sta   <Pointer
0505 C12B 90 02                 bcc   ExitAddPtr
0506 C12D E6 0B                 inc   <Pointer+2
0507 C12F 60           ExitAddPtr rts   
0508 C130
0509 C130              **********************************************************************
0510 C130              * Get and validate forward link to next message. The Z flag is set or
0511 C130              * clear to indicate whether or not the link is valid or not.
0512 C130              **********************************************************************
0513 C130
0514 C130                       entry Delink 
0515 C130              Delink                                  ;
0516 C130 A7 09                 lda   [<Pointer]
0517 C132 85 03                 sta   <MessageHandle           ;get forward link to the
0518 C134 A0 02 00              ldy   #2
0519 C137 B7 09                 lda   [<Pointer],y
0520 C139 85 05                 sta   <MessageHandle+2
0521 C13B 05 03                 ora   <MessageHandle           ;next one, and validate there is one
0522 C13D 60                    rts   
0523 C13E                       ENDP 
0524 C13E
0525 C13E
0526 C13E
0527 C13E                       END   
